using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
namespace takmicenje
{
	internal class Program
	{
        struct Potez
        {
            public int X, Y;
            public int Index;
            public double Len;
        }
        static void Main(string[] args)
        {
            int n = int.Parse(Console.ReadLine());
            (int x, int y)[] potezi = new (int x, int y)[n];
            for(int i = 0; i < n; i++)
            {
                string line = Console.ReadLine();
                string[] linea = line.Split();
                potezi[i] = (int.Parse(linea[0]), int.Parse(linea[1]));
            }
            Potez[] Potezs = new Potez[n];
            for (int i = 0; i < n; i++)
            {
                Potezs[i] = new Potez
                {
                    X = potezi[i].x,
                    Y = potezi[i].y,
                    Index = i,
                    Len = Math.Sqrt(potezi[i].x * potezi[i].x +
                                    potezi[i].y * potezi[i].y)
                };
            }
            Array.Sort(Potezs, (a, b) => b.Len.CompareTo(a.Len));
            double[] ost = new double[n + 1];
            for (int i = n - 1; i >= 0; i--)
                ost[i] = ost[i + 1] + Potezs[i].Len;

            double maxrazd = 0;
            List<int> bi = new();

            void DFS(int index, int x, int y, List<int> izbor)
            {
                double razd = Math.Sqrt(x * x + y * y);

                if (izbor.Count > 0 && razd > maxrazd)
                {
                    maxrazd = razd;
                    bi = new List<int>(izbor);
                }
                if (razd + ost[index] <= maxrazd)
                    return;

                if (index == n)
                    return;
                izbor.Add(Potezs[index].Index + 1);
                DFS(
                    index + 1,
                    x + Potezs[index].X,
                    y + Potezs[index].Y,
                    izbor
                );
                izbor.RemoveAt(izbor.Count - 1);
                DFS(index + 1, x, y, izbor);
            }
            DFS(0, 0, 0, new List<int>());
            Console.WriteLine(bi.Count);
            Console.WriteLine(string.Join(" ", bi));
        }
    }
}